// $Id: CTime.cpp,v 1.5 2007/02/08 21:06:44 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CTime.hpp"
using Exponent::Host::CTime;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CTime, CCountedObject);

//	===========================================================================
const char *CTime::CTIME_DAY_OF_THE_WEEK[] =
{
	"Sunday",
	"Monday",
	"Tuesday",
	"Wednesday",
	"Thursday",
	"Friday",
	"Saturday"
};

//	===========================================================================
const char *CTime::CTIME_MONTH_OF_THE_YEAR[] =
{
	"January",
	"February",
	"March",
	"April",
	"May",
	"June",
	"July",
	"August",
	"September",
	"October",
	"November",
	"December"
};

//	===========================================================================
CTime::CTime()
	 : m_year(0)
	 , m_month(0)
	 , m_dayOfWeek(0)
	 , m_day(0)
	 , m_hour(0)
	 , m_minutes(0)
	 , m_seconds(0)
	 , m_milliseconds(0)
{
	EXPONENT_CLASS_CONSTRUCTION(CTime);
	this->setToCurrentTime();
}

#ifdef WIN32
//	===========================================================================
CTime::CTime(FILETIME &fileTime)
	 : m_year(0)
	 , m_month(0)
	 , m_dayOfWeek(0)
	 , m_day(0)
	 , m_hour(0)
	 , m_minutes(0)
	 , m_seconds(0)
	 , m_milliseconds(0)
{
	EXPONENT_CLASS_CONSTRUCTION(CTime);
	this->setTime(fileTime);
}
#else
//	===========================================================================
CTime::CTime(DateTimeRec &time)
	 : m_year(0)
	 , m_month(0)
	 , m_dayOfWeek(0)
	 , m_day(0)
	 , m_hour(0)
	 , m_minutes(0)
	 , m_seconds(0)
	 , m_milliseconds(0)
{
	EXPONENT_CLASS_CONSTRUCTION(CTime);
	this->setTime(time);
}
#endif

//	===========================================================================
CTime::CTime(const CTime &time)
	 : m_year(0)
	 , m_month(0)
	 , m_dayOfWeek(0)
	 , m_day(0)
	 , m_hour(0)
	 , m_minutes(0)
	 , m_seconds(0)
	 , m_milliseconds(0)
{
	EXPONENT_CLASS_CONSTRUCTION(CTime);
	this->setDay(time.getDay());
	this->setDayOfWeek(time.getDayOfWeek());
	this->setHour(time.getHour());
	this->setMilliseconds(time.getMilliseconds());
	this->setMinutes(time.getMinutes());
	this->setMonth(time.getMonth());
	this->setSeconds(time.getSeconds());
}

//	===========================================================================
CTime::~CTime()
{
	EXPONENT_CLASS_DESTRUCTION(CTime);
}

//	===========================================================================
CTime &CTime::operator = (const CTime &time)
{
	this->setDay(time.getDay());
	this->setDayOfWeek(time.getDayOfWeek());
	this->setHour(time.getHour());
	this->setMilliseconds(time.getMilliseconds());
	this->setMinutes(time.getMinutes());
	this->setMonth(time.getMonth());
	this->setSeconds(time.getSeconds());
	return (*this);
}

#ifdef WIN32
//	===========================================================================
void CTime::setTime(FILETIME &fileTime)
{
	SYSTEMTIME time;
	FILETIME *ft = &fileTime;
	if (FileTimeToSystemTime(ft, &time))
	{
		this->setTime(time);
	}
}
#endif

//	===========================================================================
void CTime::setToCurrentTime()
{
#ifdef WIN32
	SYSTEMTIME time;
	GetLocalTime(&time);
	this->setTime(time);
#else
	DateTimeRec time;
	GetTime(&time);
	this->setTime(time);
#endif
}

#ifdef WIN32
//	===========================================================================
void CTime::setTime(SYSTEMTIME &time)
{
	this->setYear(time.wYear);
	this->setMonth(time.wMonth);
	this->setDayOfWeek(time.wDayOfWeek);
	this->setDay(time.wDay);
	this->setHour(time.wHour);
	this->setMilliseconds(time.wMilliseconds);
	this->setMinutes(time.wMinute);
	this->setSeconds(time.wSecond);
}
#else
//	===========================================================================
void CTime::setTime(DateTimeRec &time)
{
	this->setYear(time.year);
	this->setMonth(time.month);
	this->setDay(time.day);
	this->setHour(time.hour);
	this->setMinutes(time.minute);
	this->setSeconds(time.second);
	this->setDayOfWeek(time.dayOfWeek);
	this->setMilliseconds(0);
}
#endif

//	===========================================================================
CString CTime::getDayYearString(const bool stringFormat) const
{
	CString string;
	if (stringFormat)
	{
		string.setStringWithFormat("%s %d %s %d", CTIME_DAY_OF_THE_WEEK[m_dayOfWeek], m_day, CTIME_MONTH_OF_THE_YEAR[m_month - 1], m_year);
	}
	else
	{
		string.setStringWithFormat("%.02d/%.02d/%.04d", m_day, m_month, m_year);
	}
	return string;
}

//	===========================================================================
void CTime::getObjectDescription(char *string, const long size) const
{
	this->getTimeOnly().getString(string, size);
}

//	===========================================================================
CString CTime::getTimeOnly() const
{
	CString string;
	string.setStringWithFormat("%.02d:%.02d:%.02d:%.02d", m_hour, m_minutes, m_seconds, m_milliseconds);
	return string;
}

#ifdef WIN32
//	===========================================================================
FILETIME *CTime::getFileTime()
{
	SYSTEMTIME time;
	time.wDay			= m_day;
	time.wDayOfWeek		= m_dayOfWeek;
	time.wHour			= m_hour;
	time.wMilliseconds	= m_milliseconds;
	time.wMinute		= m_minutes;
	time.wMonth			= m_month;
	time.wSecond		= m_seconds;
	time.wYear			= m_year;
	FILETIME *ret		= new FILETIME;
	SystemTimeToFileTime(&time, ret);

	return ret;
}
#else
//	===========================================================================
DateTimeRec *CTime::getFileTime()
{
	DateTimeRec *time = new DateTimeRec;
	time->year		  = m_year;
	time->month		  = m_month;
	time->day		  = m_day;
	time->hour		  = m_hour;
	time->minute	  = m_minutes;
	time->second	  = m_seconds;
	time->dayOfWeek	  = m_dayOfWeek;
	return time;
}
#endif
